#ONOMA:LEANDROS TZANAKIS-ARNAOUTAKIS
#AEM:985
#PROVLIMA GPS ME LU

## module LUdecomp
''' a = LUdecomp(a).
    LU decomposition: [L][U] = [a]. The returned matrix [a] = [L\U]
    contains [U] in the upper triangle and the nondiagonal terms
    of [L] in the lower triangle.
    x = LUsolve(a,b).
    Solves [L][U]{x} = b, where [a] = [L\U] is the matrix returned
    from LUdecomp.
'''

from numpy import dot
from numpy import zeros,array,diagonal


a = array([[ 1.11, 2.55,2.14], \
           [2.87, 0.00,1.43 ], \
           [0.00,1.08,2.29],\
           [1.54,1.01,1.23]])               # SYNTETAGMENES THESHS
           

b = array([[1.29, 1.31,2.75, 4.06]])        # ANTISTOIXOS XRONOS




def LUdecomp(a):
    n = len(a)
    for k in range(0,n-1):
        for i in range(k+1,n):
            if a[i,k] != 0.0:
                lam = a [i,k]/a[k,k]
                a[i,k+1:n] = a[i,k+1:n] - lam*a[k,k+1:n]
                a[i,k] = lam
    return a



def LUsolve(a,b):
    n = len(b)
    for k in range(1,n):
        b[k] = b[k] - dot(a[k,0:k],b[0:k])  
    for k in range(n-1,-1,-1):
        b[k] = (b[k] - dot(a[k,k+1:n],b[k+1:n]))/a[k,k]
    return b

a=LUdecomp(a)        #KLHSH METATROPHS SE LU

x=LUsolve(a,b)       #KLISH EPILYSHS LU


print x




